﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4082 = {
    //general options and settings
    opts: {
        questions: {
            hideByDefault: function () {
                var str = 'div[id$="TID1_QID13"],div[id$="TID1_QID14"],div[id$="TID1_QID15"],div[id$="TID1_QID16"],div[id$="TID1_QID17"],div[id$="TID1_QID18"],div[id$="TID1_QID19"],' +
                          'div[id$="TID1_QID20"],div[id$="TID1_QID22"],div[id$="TID1_QID23"],div[id$="TID1_QID24"],div[id$="TID1_QID25"],div[id$="TID1_QID26"],div[id$="TID1_QID27"],div[id$="TID1_QID28"],div[id$="TID1_QID29"],' +
                          'div[id$="TID1_QID31"],div[id$="TID1_QID32"],div[id$="TID1_QID33"],div[id$="TID1_QID34"],div[id$="TID1_QID35"],div[id$="TID1_QID36"],div[id$="TID1_QID37"],div[id$="TID1_QID38"],div[id$="TID1_QID39"],' +
                          'div[id$="TID1_QID40"],div[id$="TID1_QID42"],div[id$="TID1_QID43"],div[id$="TID1_QID44"],div[id$="TID1_QID46"],div[id$="TID1_QID47"],div[id$="TID1_QID48"],' +
                          'div[id$="TID1_QID50"],div[id$="TID1_QID51"],div[id$="TID1_QID52"],div[id$="TID1_QID53"],div[id$="TID1_QID58"],div[id$="TID1_QID59"],' +
                          'div[id$="TID1_QID61"],div[id$="TID1_QID62"],div[id$="TID1_QID64"],div[id$="TID1_QID65"],div[id$="TID1_QID66"],' +
                          'div[id$="TID1_QID73"],div[id$="TID1_QID74"],div[id$="TID1_QID75"],div[id$="TID1_QID76"],div[id$="TID1_QID77"],div[id$="TID1_QID78"],div[id$="TID1_QID79"],' +
                          'div[id$="TID1_QID80"],div[id$="TID1_QID81"],div[id$="TID1_QID82"],div[id$="TID1_QID83"],div[id$="TID1_QID84"],div[id$="TID1_QID85"],div[id$="TID1_QID86"]';
                

                return $(str);
            }
        }
    },

    //hide questions by default
    hideQuestions: function () {
        var _me = this;

        $.each(_me.opts.questions.hideByDefault(), function (i, _divQ) {

            //set 'skipped' attribute
            $(_divQ).attr('skipped', true);
            $('[name^="grp"]', $(_divQ)).each(function () {
                var _name = $(this).attr('name');
                if (_name.indexOf("skip_") < 0) {
                    $(this).attr("name", "skip_" + _name);
                }
            });

            //no need to reset question's responses as is the first time loading and there are no answers
            //_me.clearQuestionResponses(_divQ);

            //hide question
            $(_divQ).hide();

        });

    },

    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //call functions here
                    _me.hideQuestions();

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 1);
            });
        });
    }
};